<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');
header("Cache-Control: no-cache");
header("Pragma: no-cache");
include("versao.php");

// URL do arquivo de texto contendo a lista de arquivos PHP a serem atualizados
$url_versao_atualizacao = 'http://syspanforcadevendas.com.br/arquivos/atualizacao.txt';
// Diretório de destino para os arquivos baixados
$diretorio_destino = 'c:/syspan/web/forcadevenda/';

// Função para fazer requisições HTTP usando fsockopen
function baixar_conteudo($url) {
    // Só funciona com HTTP, não HTTPS
    if (strpos($url, 'https://') === 0) {
        // Tenta converter para HTTP
        $url = str_replace('https://', 'http://', $url);
    }
    
    $url_parts = parse_url($url);
    if (!$url_parts) {
        return false;
    }
    
    $host = $url_parts['host'];
    $port = isset($url_parts['port']) ? $url_parts['port'] : 80;
    $path = isset($url_parts['path']) ? $url_parts['path'] : '/';
    if (isset($url_parts['query'])) {
        $path .= '?' . $url_parts['query'];
    }
    
    $fp = fsockopen($host, $port, $errno, $errstr, 30);
    if (!$fp) {
        return false;
    }
    
    $request = "GET $path HTTP/1.1\r\n";
    $request .= "Host: $host\r\n";
    $request .= "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36\r\n";
    $request .= "Connection: close\r\n\r\n";
    
    fwrite($fp, $request);
    
    $response = '';
    while (!feof($fp)) {
        $response .= fgets($fp, 1024);
    }
    fclose($fp);
    
    // Separa headers do body
    $parts = explode("\r\n\r\n", $response, 2);
    if (count($parts) >= 2) {
        // Verifica se foi um HTTP 200 OK
        if (strpos($response, 'HTTP/1.1 200 OK') !== false || strpos($response, 'HTTP/1.0 200 OK') !== false) {
            return $parts[1];
        }
    }
    
    return false;
}

// Função para verificar se há atualizações disponíveis e atualizar
function verificar_atualizacoes($url_versao_atualizacao, $diretorio_destino) {
    $mensagens = array(); // Array para armazenar as mensagens de retorno
    $sucesso = false; // Variável para controlar se houve sucesso na atualização
    
    // Diretório de backup
    $diretorio_backup = $diretorio_destino . 'backup' . DIRECTORY_SEPARATOR;
    
    // Obtém a versão atual do sistema
    $versao_atual = defined('VERSAO_SISTEMA') ? VERSAO_SISTEMA : null;
    
    // Debug: mostra a versão atual
    $mensagens[] = array("status" => "debug", "message" => "Versão atual lida: " . ($versao_atual ? $versao_atual : 'NULL'));
    
    // Verifica se a leitura da versão teve sucesso
    if ($versao_atual !== null) {
        // Debug: tentando baixar arquivo
        $mensagens[] = array("status" => "debug", "message" => "Tentando baixar: $url_versao_atualizacao");
        
        // Obtém o conteúdo do arquivo de texto usando cURL
        $conteudo_arquivo = baixar_conteudo($url_versao_atualizacao);
        
        // Debug: resultado do download
        $mensagens[] = array("status" => "debug", "message" => "Conteúdo baixado: " . ($conteudo_arquivo !== false ? "SIM" : "NÃO"));
        
        if ($conteudo_arquivo !== false) {
            // Debug: mostra primeiros caracteres do arquivo
            $mensagens[] = array("status" => "debug", "message" => "Primeiros 100 chars: " . substr($conteudo_arquivo, 0, 100));
            
            // Converte o conteúdo em linhas
            $linhas_temp = explode("\n", trim($conteudo_arquivo));
            $linhas_arquivo = array();
            
            // Remove linhas vazias manualmente (compatível com PHP 5)
            foreach ($linhas_temp as $linha) {
                $linha_limpa = trim($linha);
                if ($linha_limpa !== '') {
                    $linhas_arquivo[] = $linha_limpa;
                }
            }
            
            // Debug: mostra quantas linhas foram encontradas
            $mensagens[] = array("status" => "debug", "message" => "Linhas encontradas: " . count($linhas_arquivo));
        } else {
            $linhas_arquivo = false;
        }
        
        // Verifica se o conteúdo foi obtido com sucesso
        if ($linhas_arquivo !== false && count($linhas_arquivo) > 0) {
            // Debug: mostra primeira linha
            $mensagens[] = array("status" => "debug", "message" => "Primeira linha: " . $linhas_arquivo[0]);
            
            // Verifica se a primeira linha parece ser uma versão (formato x.x.x)
            $primeira_linha = trim($linhas_arquivo[0]);
            $eh_versao = preg_match('/^\d+\.\d+(\.\d+)?$/', $primeira_linha);
            
            if ($eh_versao) {
                // Primeira linha é versão - comportamento original
                $versao_atualizacao = $primeira_linha;
                $mensagens[] = array("status" => "debug", "message" => "Versão encontrada: $versao_atualizacao");
                
                // Compara as versões
                if (version_compare($versao_atualizacao, $versao_atual, '>')) {
                    // Remove a primeira linha (versão) do array
                    array_shift($linhas_arquivo);
                    $fazer_atualizacao = true;
                } else {
                    $mensagens[] = array("status" => "success", "message" => "Não há novas atualizações disponíveis - Versão atual: $versao_atual | Versão do arquivo: $versao_atualizacao");
                    $fazer_atualizacao = false;
                }
            } else {
                // Primeira linha não é versão - forçar atualização
                $mensagens[] = array("status" => "debug", "message" => "Nenhuma versão encontrada no arquivo - forçando atualização");
                $fazer_atualizacao = true;
            }
            
            if ($fazer_atualizacao) {
                // A versão do arquivo de atualização é maior que a versão atual, proceda com as atualizações
                
                // Cria o diretório de backup se não existir
                if (!is_dir($diretorio_backup)) {
                    if (!mkdir($diretorio_backup, 0755, true)) {
                        $mensagens[] = array("status" => "error", "message" => "Erro ao criar o diretório de backup");
                        return $mensagens;
                    }
                }
                
                // Itera sobre as linhas dos arquivos
                foreach ($linhas_arquivo as $arquivo) {
                    // Remove espaços em branco extras
                    $arquivo = trim($arquivo);
                    
                    // Pula arquivos vazios
                    if (empty($arquivo)) {
                        continue;
                    }
                    
                    // Caminho completo do arquivo local
                    $caminho_completo = $diretorio_destino . DIRECTORY_SEPARATOR . $arquivo;
                    
                    // URL do arquivo no servidor remoto
                    $url_arquivo = str_replace(' ', '%20', dirname($url_versao_atualizacao) . '/' . $arquivo);
                    
                    // Obtém o conteúdo atualizado do arquivo usando cURL
                    $conteudo_atualizado = baixar_conteudo($url_arquivo);
                    
                    // Se o conteúdo não for vazio, copia e renomeia o arquivo
                    if ($conteudo_atualizado !== false && !empty($conteudo_atualizado)) {
                        // Caminho do novo arquivo temporário
                        $novo_arquivo = $diretorio_destino . DIRECTORY_SEPARATOR . basename($arquivo);
                        
                        // Copia o conteúdo atualizado para o arquivo temporário
                        if (file_put_contents($novo_arquivo, $conteudo_atualizado) !== false) {
                            // Renomeia o arquivo temporário para o nome desejado
                            $novo_nome = $diretorio_destino . DIRECTORY_SEPARATOR . pathinfo($arquivo, PATHINFO_FILENAME) . '.php';
                            
                            // Verifica se o arquivo existe localmente
                            if (file_exists($novo_nome)) {
                                // Cria o caminho do arquivo de backup
                                $arquivo_backup = $diretorio_backup . pathinfo($arquivo, PATHINFO_FILENAME) . '_' . date('Y-m-d_H-i-s') . '.php';
                                
                                // Copia o arquivo antigo para o backup antes de substituí-lo
                                if (copy($novo_nome, $arquivo_backup)) {
                                    // Arquivo copiado para backup com sucesso, agora pode excluir o original
                                    unlink($novo_nome);
                                } else {
                                    // Erro ao fazer backup - adiciona mensagem de erro
                                    $mensagens[] = array("status" => "error", "message" => "Erro ao fazer backup do arquivo " . pathinfo($arquivo, PATHINFO_FILENAME) . '.php');
                                    continue; // Pula para o próximo arquivo
                                }
                            }
                            
                            if (rename($novo_arquivo, $novo_nome)) {
                                // Define sucesso como true se ainda não foi definido
                                if (!$sucesso) {
                                    $sucesso = true;
                                    // Adiciona mensagem de sucesso ao array
                                    $mensagens[] = array("status" => "success", "message" => "Arquivos atualizados com sucesso e backup criado");
                                }
                            } else {
                                // Adiciona mensagem de erro ao array
                                $mensagens[] = array("status" => "error", "message" => "Erro ao renomear o arquivo $arquivo");
                            }
                        } else {
                            // Adiciona mensagem de erro ao array
                            $mensagens[] = array("status" => "error", "message" => "Erro ao copiar o arquivo $arquivo");
                        }
                    } else {
                        // Adiciona mensagem de erro ao array
                        $mensagens[] = array("status" => "error", "message" => "Erro ao obter o conteúdo do arquivo $arquivo");
                    }
                }
            } else {
                // Adiciona mensagem de sucesso indicando que não há atualizações disponíveis
                $mensagens[] = array("status" => "success", "message" => "Não há novas atualizações disponíveis - Versão atual: $versao_atual | Versão do arquivo: $versao_atualizacao");
            }
        } else {
            // Adiciona mensagem de erro ao array
            $mensagens[] = array("status" => "error", "message" => "Erro: Não foi possível obter a versão do arquivo de atualização");
        }
    } else {
        // Adiciona mensagem de erro ao array
        $mensagens[] = array("status" => "error", "message" => "Erro: Versão não identificada.");
    }
    
    // Retorna o array de mensagens
    return $mensagens;
}

// Verifica se há atualizações disponíveis e atualiza
$mensagens_retorno = verificar_atualizacoes($url_versao_atualizacao, $diretorio_destino);

// Exibe as mensagens de retorno como JSON
echo json_encode($mensagens_retorno);
?>