<?php
// Configurações de erro mais agressivas
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
ini_set('log_errors', 1);
error_reporting(E_ALL);

// Log de início para debug
error_log("Script iniciado: " . date('Y-m-d H:i:s'));

try {
    // Só define o header depois de ter certeza que não há erros
    header('Content-Type: application/json');
    
    // Token de segurança
    $tokenEsperado = '7f59f2f08ebf17f396f9a2026ccca03e';
    
    // Debug: verificar se o token foi recebido
    error_log("Token recebido: " . (isset($_GET['token']) ? $_GET['token'] : 'NENHUM'));
    
    if (!isset($_GET['token']) || $_GET['token'] !== $tokenEsperado) {
        http_response_code(403);
        echo json_encode(['erro' => 'Token inválido']);
        exit;
    }
    
    // Debug: verificar diretório atual
    $diretorioAtual = getcwd();
    error_log("Diretório atual: " . $diretorioAtual);
    
    // Verificar se a função glob existe
    if (!function_exists('glob')) {
        throw new Exception('Função glob() não está disponível');
    }
    
    // Tentar listar arquivos
    $arquivos = glob("*.php");
    
    // Debug: verificar resultado do glob
    if ($arquivos === false) {
        throw new Exception('glob() retornou false - erro ao ler diretório');
    }
    
    error_log("Arquivos encontrados: " . count($arquivos));
    
    $dados = [];
    foreach ($arquivos as $arquivo) {
        // Verificar se o arquivo realmente existe
        if (file_exists($arquivo)) {
            $dados[] = ['nome' => $arquivo];
        }
    }
    
    // Debug: verificar dados antes do JSON
    error_log("Dados para JSON: " . print_r($dados, true));
    
    // Verificar se json_encode funcionará
    $json = json_encode($dados);
    if ($json === false) {
        throw new Exception('Erro ao codificar JSON: ' . json_last_error_msg());
    }
    
    echo $json;
    error_log("Script finalizado com sucesso");
    
} catch (Exception $e) {
    error_log("ERRO: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['erro' => $e->getMessage()]);
} catch (Error $e) {
    error_log("FATAL ERROR: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['erro' => 'Erro fatal: ' . $e->getMessage()]);
}
?>