<?php
    // Desativar exibição de erros
    error_reporting(false);
    
    // Definir o tipo de conteúdo e desativar cache    
    ini_set("zlib.output_compression","On");
    ini_set("zlib.output_compression_level","9");
    header('Content-Type: application/json');
    header("Cache-Control: no-cache");
    header("Pragma: no-cache");
    
    // Habilitar CORS    
    include("enableCORS.php");
    enableCORS();
    
    // Recuperar parâmetros de entrada
    $bd  = $_REQUEST['bd'];
    $codcliente = $_REQUEST['cliente'];
    
    // Inicializar matriz de resultados    
    $matriz = array();
    
    // Conectar ao banco de dados
    include("conexao.php");    
    
    if ($codcliente != 0){
        // chama a procedure para popular a tabela
        $sql  = sprintf("call sp_historico_pedidovenda_cliente(%s) ",mysqli_real_escape_string($con, $codcliente));
        $result = mysqli_query($con, $sql);
        if (!$result) {
            die(json_encode(array("tipo"=>'mix',"erro_query"=> mysqli_error($con))));
        }     
        // RETORNAR REGISTROS
        $sql = sprintf("SELECT
            historico_pedidovenda.cod_cliente,
            produtos.desc_reduzida,
            produtos.unidade,
            produtos.cod_barras,
            historico_pedidovenda.cod_produto,
            historico_pedidovenda.ultimo_valor_vendido,
            historico_pedidovenda.maior_qtde_vendida,
            historico_pedidovenda.ultima_qtde_vendida,
            historico_pedidovenda.data_ultima_venda,
            IFNULL(produtos.qtd_atual_estoque,0.000000000) AS qtd_estoque,
            IFNULL(cod_fabricante,'') AS cod_fabricante
            FROM historico_pedidovenda 
            INNER JOIN produtos ON (historico_pedidovenda.cod_produto = produtos.codigo)
            WHERE historico_pedidovenda.cod_cliente = '%s'",mysqli_real_escape_string($con, $codcliente));
    } else {
        // RETORNAR REGISTROS
        $sql = "SELECT
            historico_pedidovenda.cod_cliente,
            produtos.desc_reduzida,
            produtos.unidade,
            produtos.cod_barras,
            historico_pedidovenda.cod_produto,
            historico_pedidovenda.ultimo_valor_vendido,
            historico_pedidovenda.maior_qtde_vendida,
            historico_pedidovenda.ultima_qtde_vendida,
            historico_pedidovenda.data_ultima_venda,
            IFNULL(produtos.qtd_atual_estoque,0.000000000) AS qtd_estoque,
            IFNULL(cod_fabricante,'') AS cod_fabricante
            FROM historico_pedidovenda 
            INNER JOIN produtos ON (historico_pedidovenda.cod_produto = produtos.codigo)
            ORDER BY historico_pedidovenda.cod_cliente ASC";
    }
    $mix = mysqli_query($con, $sql);
    $num = mysqli_num_rows($mix);
    if($num != 0){
        while($ls = mysqli_fetch_array($mix)) {    
            $matriz[] = array("tipo"=>'mix',"qtde_produtos"=>$num,
                "cod_cliente"=> $ls['cod_cliente'],    
                "desc_reduzida"=> $ls['desc_reduzida'],
                "unidade"=> $ls['unidade'],
                "cod_barras"=> $ls['cod_barras'],
                "cod_produto"=> $ls['cod_produto'], 
                "ultimo_valor_vendido"=> $ls['ultimo_valor_vendido'],
                "maior_qtde_vendida"=> $ls['maior_qtde_vendida'],
                "ultima_qtde_vendida"=> $ls['ultima_qtde_vendida'],
                "data_ultima_venda"=> $ls['data_ultima_venda'],                    
                "qtd_estoque"=> $ls['qtd_estoque'],
                "cod_fabricante"=> $ls['cod_fabricante']);    
        }
    } else {
        $matriz[] =  array("tipo"=>'mix',"qtde_produtos"=>$num);        
    }    
    echo json_encode($matriz); 
?>
