<?php

// error_reporting(0);
error_reporting(E_ALL);
ini_set('display_errors', 1);

/* Importa o arquivo onde a função de upload está implementada */
require_once('funcao_upload.php');

/* Verifica se existem arquivos enviados */
$arquivos = array();
if (isset($_FILES['pasta_de_video'])) {
    $arquivos = $_FILES['pasta_de_video'];
}

$tipos = array('mp4');  // Define os tipos de arquivos válidos
$data = ['sucesso' => false, 'msg' => '']; // Inicializa a estrutura de resposta

/* Verifica se há arquivos para processar */
if (!empty($arquivos) && is_array($arquivos['name'])) {
    $caminhos = [];

    foreach ($arquivos['name'] as $index => $nomeArquivo) {

        if($arquivos["type"][$index] == 'video/mp4') {
            
            $arquivo = [
                'name' => $arquivos['name'][$index],
                'type' => $arquivos['type'][$index],
                'tmp_name' => $arquivos['tmp_name'][$index],
                'error' => $arquivos['error'][$index],
                'size' => $arquivos['size'][$index],
            ];
            
        
            // var_dump($arquivo);

            // Chama a função para enviar o arquivo
            $enviar = uploadFile($arquivo, 'uploads/', $tipos);

            if (isset($enviar['erro'])) {
                $data['msg'] .= $enviar['erro'] . "; ";
            } else {
                $caminhos[] = $enviar['caminho'];
            }
        }
    }

    if (!empty($caminhos)) {
        $data['sucesso'] = true;
        $data['msg'] = implode(',', $caminhos);  // Junta os caminhos com vírgula
    }
} else {
    $data['msg'] = "Nenhum arquivo foi enviado.";
}

/* Codifica a variável array $data para o formato JSON */
echo json_encode($data);
